/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.editor.php.internal.model.impl;

import com.aptana.editor.php.core.model.IField;
import com.aptana.editor.php.core.model.IMethod;
import com.aptana.editor.php.core.model.IModelElement;
import com.aptana.editor.php.core.model.ISourceRange;
import com.aptana.editor.php.core.model.IType;
import com.aptana.editor.php.core.model.env.ModelElementInfo;
import com.aptana.editor.php.indexer.EntryUtils;
import com.aptana.editor.php.indexer.IElementEntry;
import com.aptana.editor.php.indexer.PHPGlobalIndexer;
import com.aptana.editor.php.internal.indexer.ClassPHPEntryValue;
import com.aptana.editor.php.internal.model.impl.AbstractMember;
import com.aptana.editor.php.internal.model.impl.SourceRange;
import com.aptana.editor.php.internal.model.impl.env.SourceTypeElementInfo;
import com.aptana.editor.php.internal.model.utils.ModelUtils;
import com.aptana.editor.php.internal.model.utils.TypeHierarchyUtils;
import com.aptana.editor.php.internal.model.utils.TypeUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org2.eclipse.php.core.compiler.PHPFlags;

public class EntryBasedType
extends AbstractMember
implements IType {
    private ClassPHPEntryValue entryValue;

    public EntryBasedType(IElementEntry typeEntry) {
        super(typeEntry);
        if (!EntryUtils.isType(typeEntry)) {
            throw new IllegalArgumentException("type entry required");
        }
        this.entryValue = (ClassPHPEntryValue)typeEntry.getValue();
    }

    public IField getField(String fieldName) {
        List<IField> fields = this.getFields();
        for (IField field : fields) {
            if (!fieldName.equals(field.getElementName())) continue;
            return field;
        }
        return null;
    }

    public List<IField> getFields() {
        List<IElementEntry> fieldEntries = TypeUtils.getFields(this.getEntry());
        List<IModelElement> converted = ModelUtils.convertEntries(fieldEntries);
        ArrayList<IField> result = new ArrayList<IField>();
        for (IModelElement element : converted) {
            if (!(element instanceof IField)) continue;
            result.add((IField)element);
        }
        return result;
    }

    public List<String> getInterfaceNames() {
        return this.entryValue.getInterfaces();
    }

    public List<IType> getInterfaces() {
        List<String> interfaceNames = this.getInterfaceNames();
        if (interfaceNames == null || interfaceNames.size() == 0) {
            return Collections.emptyList();
        }
        List<IElementEntry> ancestors = TypeHierarchyUtils.getDirectClassAncestors(this.getEntry().getModule(), this.getElementName(), PHPGlobalIndexer.getInstance().getIndex());
        ArrayList<IType> result = new ArrayList<IType>();
        for (IElementEntry entry : ancestors) {
            if (!EntryUtils.isInterface(entry)) continue;
            result.add((IType)ModelUtils.convertEntry(entry));
        }
        return result;
    }

    public List<IMethod> getMethods() {
        List<IElementEntry> methodEntries = TypeUtils.getMethods(this.getEntry());
        List<IModelElement> converted = ModelUtils.convertEntries(methodEntries);
        ArrayList<IMethod> result = new ArrayList<IMethod>();
        for (IModelElement element : converted) {
            if (!(element instanceof IMethod)) continue;
            result.add((IMethod)element);
        }
        return result;
    }

    public List<IMethod> getMethods(String methodName) {
        List<IMethod> methods = this.getMethods();
        ArrayList<IMethod> result = new ArrayList<IMethod>();
        for (IMethod method : methods) {
            if (!methodName.equals(method.getElementName())) continue;
            result.add(method);
        }
        return result;
    }

    public boolean isInterface() {
        return PHPFlags.isInterface((int)this.entryValue.getModifiers());
    }

    public int getFlags() {
        return this.entryValue.getModifiers();
    }

    public ISourceRange getNameRange() {
        return new SourceRange(this.entryValue.getStartOffset());
    }

    public int getElementType() {
        return 7;
    }

    public List<IType> getSuperClasses() {
        List<String> superClassNames = this.getSuperClassNames();
        if (superClassNames == null || superClassNames.size() == 0) {
            return null;
        }
        List<IElementEntry> ancestors = TypeHierarchyUtils.getDirectClassAncestors(this.getEntry().getModule(), this.getElementName(), PHPGlobalIndexer.getInstance().getIndex());
        for (IElementEntry entry : ancestors) {
            if (EntryUtils.isInterface(entry)) continue;
            ArrayList<IType> result = new ArrayList<IType>();
            result.add((IType)ModelUtils.convertEntry(entry));
            return result;
        }
        return null;
    }

    public List<String> getSuperClassNames() {
        String superClassName = this.entryValue.getSuperClassname();
        if (superClassName == null) {
            return Collections.emptyList();
        }
        ArrayList<String> result = new ArrayList<String>();
        result.add(superClassName);
        return result;
    }

    public List<IType> getSuperTypes() {
        List<String> interfaceNames = this.getInterfaceNames();
        List<String> superClassNames = this.getSuperClassNames();
        if (!(interfaceNames != null && interfaceNames.size() != 0 || superClassNames != null && superClassNames.size() != 0)) {
            return Collections.emptyList();
        }
        List<IElementEntry> ancestors = TypeHierarchyUtils.getDirectClassAncestors(this.getEntry().getModule(), this.getElementName(), PHPGlobalIndexer.getInstance().getIndex());
        ArrayList<IType> result = new ArrayList<IType>();
        for (IElementEntry entry : ancestors) {
            result.add((IType)ModelUtils.convertEntry(entry));
        }
        return result;
    }

    public String toString() {
        return this.getElementName();
    }

    @Override
    public ModelElementInfo getElementInfo() {
        List<String> superClassNames;
        SourceTypeElementInfo info = new SourceTypeElementInfo();
        info.setFlags(this.getFlags());
        info.setNameSourceStart(this.getSourceRange().getOffset());
        List<IModelElement> children = this.getChildren();
        if (children != null && children.size() != 0) {
            info.setChildren(children);
        }
        if ((superClassNames = this.getSuperClassNames()) != null && superClassNames.size() != 0) {
            info.setSuperclassNames(superClassNames.toArray(new String[superClassNames.size()]));
        }
        return info;
    }
}

